//this file is part of eMule
//Copyright (C)2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include <stdafx.h>
#include "NetF.h"
#include "Preferences.h"
#include "StringConversion.h"
#include "ini2.h"
#include <Mmsystem.h>

CNetF	theNetF;

CNetF::CNetF()
{
	// Status
	m_bHighIdPossible = false;
	// Statistics
	m_iSessionSuccessfulDownloadNNP = 0;
	m_iSessionSuccessfulDownloadLimit = 0;
	m_iSessionSuccessfulDownloadTimeout = 0;
	m_iSessionSuccessfulDownloadDisconnect = 0;
	m_iSessionSuccessfulDownloadDropped = 0;
	m_iSessionSuccessfulDownloadOther = 0;
	m_iSessionFailedDownloadNNP = 0;
	m_iSessionFailedDownloadLimit = 0;
	m_iSessionFailedDownloadTimeout = 0;
	m_iSessionFailedDownloadDisconnect = 0;
	m_iSessionFailedDownloadDropped = 0;
	m_iSessionFailedDownloadOther = 0;
	m_iSessionSuccessfulUploadCancel = 0;
	m_iSessionSuccessfulUploadTimeout = 0;
	m_iSessionSuccessfulUploadDisconnect = 0;
	m_iSessionSuccessfulUploadLimit = 0;
	m_iSessionSuccessfulUploadOther = 0;
	m_iSessionFailedUploadCancel = 0;
	m_iSessionFailedUploadTimeout = 0;
	m_iSessionFailedUploadDisconnect = 0;
	m_iSessionFailedUploadLimit = 0;
	m_iSessionFailedUploadUnreachable = 0;
	m_iSessionFailedUploadRejected = 0;
	m_iSessionFailedUploadOther = 0;
	theNetF.m_nSessionUploadedLAN = 0;
	theNetF.m_nSessionDownloadedLAN = 0;
	// Configuration
	m_bSymmetricTCP = false;
	m_iTaskPriority = TP_Normal;
	m_iSmallFilePush = SFP_Nonlinear;
	// Features
	m_bVIPQueue = true;
}

CNetF::~CNetF()
{
	//SavePreferences();
}

void CNetF::Init()
{
	LoadPreferences();
}

void CNetF::SavePreferences() const
{
	USES_CONVERSION;
	CString buffer;
	TCHAR* fullpath = new TCHAR[_tcslen(thePrefs.GetMuleDirectory(EMULE_CONFIGDIR))+MAX_PATH]; // i_a
	_stprintf(fullpath,_T("%sNetF.ini"),thePrefs.GetMuleDirectory(EMULE_CONFIGDIR));
	
	CIni ini( fullpath, _T("NetF") );
	delete[] fullpath;
	fullpath=NULL;
	
	ini.WriteBool(_T("SymmetricTCP"), m_bSymmetricTCP);
	ini.WriteInt(_T("TaskPriority"), m_iTaskPriority);

	ini.WriteInt(_T("SmallFilePush"), m_iSmallFilePush, _T("CreditSystem"));

	ini.WriteBool(_T("VIPQueue"), m_bVIPQueue, _T("Features"));
}

void CNetF::LoadPreferences()
{
	USES_CONVERSION;
	CString buffer;
	TCHAR* fullpath = new TCHAR[_tcslen(thePrefs.GetMuleDirectory(EMULE_CONFIGDIR))+MAX_PATH]; // i_a
	_stprintf(fullpath,_T("%sNetF.ini"),thePrefs.GetMuleDirectory(EMULE_CONFIGDIR));
	
	CIni ini( fullpath, _T("NetF") );
	delete[] fullpath;
	fullpath=NULL;

	m_bSymmetricTCP = ini.GetBool(_T("SymmetricTCP"), false);
	m_iTaskPriority = (ETaskPriority) ini.GetInt(_T("TaskPriority"), TP_Normal);
	UpdateTaskPriority();

	m_iSmallFilePush = (ESmallFilePush) ini.GetInt(_T("SmallFilePush"), SFP_Nonlinear, _T("CreditSystem"));

	m_bVIPQueue = ini.GetBool(_T("VIPQueue"), true, _T("Features"));
}

void CNetF::UpdateTaskPriority()
{
	switch(m_iTaskPriority)
	{
	case TP_Low:
		SetPriorityClass(GetCurrentProcess(), IDLE_PRIORITY_CLASS);
		break;
	case TP_BelowNormal:
		SetPriorityClass(GetCurrentProcess(), BELOW_NORMAL_PRIORITY_CLASS);
		break;
	case TP_AboveNormal:
		SetPriorityClass(GetCurrentProcess(), ABOVE_NORMAL_PRIORITY_CLASS);
		break;
	case TP_High:
		SetPriorityClass(GetCurrentProcess(), HIGH_PRIORITY_CLASS);
		break;
	case TP_Normal:
	default:
		SetPriorityClass(GetCurrentProcess(), NORMAL_PRIORITY_CLASS);
		break;
	}
}

/*void
CNetF::LoadLocale(const CString& strLanguage)
{
	USES_CONVERSION;
	CString buffer;
	TCHAR* fullpath = new TCHAR[_tcslen(thePrefs.GetLangDir())+MAX_PATH];
	_stprintf(fullpath,_T("%sNetF_%s.ini"),thePrefs.GetLangDir(),strLanguage);
	
	CIni ini( fullpath, _T("Strings") );
	delete[] fullpath;
	fullpath=NULL;

	m_mapLocaleStrings.RemoveAll();
	m_mapLocaleStrings.InitHashTable(101);
	
	// OK, I now! The following code sucks!

	int		nID;
	CString strID;
	CString strTranslation;
	nID = 5000;
	strID.Format(_T("%d"), nID); 
	while ((strTranslation = ini.GetString(strID, _T("!EOF!"))) != _T("!EOF!"))
	{
		m_mapLocaleStrings.SetAt(nID, strTranslation);
		++nID;
		strID.Format(_T("%d"), nID); 
	}
	nID = 5500;
	strID.Format(_T("%d"), nID); 
	while ((strTranslation = ini.GetString(strID, _T("!EOF!"))) != _T("!EOF!"))
	{
		m_mapLocaleStrings.SetAt(nID, strTranslation);
		++nID;
		strID.Format(_T("%d"), nID); 
	}
	nID = 5800;
	strID.Format(_T("%d"), nID); 
	while ((strTranslation = ini.GetString(strID, _T("!EOF!"))) != _T("!EOF!"))
	{
		m_mapLocaleStrings.SetAt(nID, strTranslation);
		++nID;
		strID.Format(_T("%d"), nID); 
	}
}*/

/*const CString&
CNetF::GetLocaleString(UINT nID, const CString& strDefault)
{
	CLocMap::CPair*	pKeyPair = m_mapLocaleStrings.PLookup(nID);
	if (pKeyPair != NULL)
	{
		return pKeyPair->value;
	}
	else
	{
		return strDefault;
	}
}**/